<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    use HasFactory;

    protected $table = 'currencies';
    protected $primaryKey = 'Currency_id';
    public $incrementing = true;
    public $timestamps = true;

    protected $fillable = [
        'Code',
        'Symbol',
        'Exchange_rate',
    ];

    protected $casts = [
        'Exchange_rate' => 'decimal:4',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];
}
